/**
 * Created by kal on 06/06/2017.
 */
var resultsvisible;
var types = ["All","Indoor","Outdoor"];
//var indoor_locations = ["All","North","South"];
var regionsNeeded = [];

var locations = {
    "North":[
        "West Midlands",
        "East Midlands",
        "Yorkshire and the Humber",
        "North West",
        "North East"
    ],
    "South":[
        "South West",
        "South East",
        "London",
        "East of England"
    ],
    "Wales":[
        "Wales"
    ]
};

function getArea(region){//e.g. London -> South, North West -> North
    for(var key in locations){
        if(locations[key].includes(region)){
            return key;
        }
    }
}

function filterRegions(val){
    return regionsNeeded.includes(val);
}
function filterAreas(val){
    return val.length > 0;
}

$(function(){
    try{
        var params = window.location.search.substring(1).split('=')
        $('#' + params[0]).val(params[1]);
    }catch(e){

    }


    var searchForm = $("#search-form");

    var projects = $(".project");


    //make a list of regions that have projects in
    for(var i = 0; i < projects.length; i ++){
        console.log(projects[i].getAttribute("data-location"));
        regionsNeeded.push(projects[i].getAttribute("data-location"));
    }

    //filter locations to remove unused regions
    for(var i in locations){
        //console.log(locations[i].filter(filterRegions));
        locations[i] = locations[i].filter(filterRegions);
    }
    for (var i in locations){
        if(locations[i].length == 0){
            delete locations[i];
        }
    }


    //load types
    // for (var key in types){
    //     $("#type-selector").append('<option value="' + types[key] + '">' + types[key] + '</option>');
    // }



    // for (var i in indoor_locations) {
    //     //console.log(indoor_locations[i]);
    //     $("#location-selector").append('<option value="' + indoor_locations[i] + '">' + indoor_locations[i] + '</option>');
    // }

    loadLocations();

    $(searchForm).submit(function(event){
        event.preventDefault();
        var searchval_location = $("#location-selector").val();
        var searchval_type = $("#type-selector").val();
        var projects = $(".project");
        var projectDividers = $(".project-divider");

        for( var i = 0; i < projects.length; i ++){
            var data_location = projects[i].getAttribute('data-location');
            var data_type = projects[i].getAttribute('data-type');
            if((data_location === searchval_location || //correct location
                searchval_location === "All" || //location doesnt matter
                getArea(data_location) === searchval_location) && //searching by area, check if in correct area
                (data_type === searchval_type || //correct type
                searchval_type === "All")){ //type doesnt matter
                $(projects[i]).addClass('result');
                $(projectDividers[i]).addClass('resultdivider');
                //$(projects[i]).removeClass('hidden');
                //$(projectDividers[i]).removeClass('hidden');
            }else{
                $(projects[i]).removeClass('result');
                $(projectDividers[i]).removeClass('resultdivider');
                $(projects[i]).addClass('hidden');
                $(projectDividers[i]).addClass('hidden');
            }
        }
        showTopResults(3);
        //remove last visible divider, so there isnt a double divider at the bottom
        //there needs to be one in html otherwise divider numbering fucks up
        //var visibleDividers = $(".project-divider:not(.hidden)");
        //$(visibleDividers[visibleDividers.length - 1]).addClass('hidden');

        if($(".result").length === 0){
            $("#searchMessage").text("No results");
        }else{
            $("#searchMessage").text("");
        }
        //$("#showmore").removeClass('hidden');
        $("#pleaseenquire").removeClass('hidden');

    });
    $('#showmore').click(function(){
        showTopResults(resultsvisible + 5);
    });

});

function showTopResults(x){

    if(x >= $('.result').length){
        $('#showmore').addClass('hidden');
        x = $('.result').length;
    }else{
        $("#showmore").removeClass('hidden');
    }
    $('.result').addClass('hidden');
    $('.result:lt(' + x + ')').removeClass('hidden');
    $('.resultdivider').addClass('hidden');
    $('.resultdivider:lt(' + (x - 1) + ')').removeClass('hidden');
    resultsvisible = x;
}

function loadLocations(){
    var locationSelector = $('#location-selector');
    locationSelector.children().remove();
    var projects = $(".project");
    if($("#type-selector").val() == "Indoor"){
        $(locationSelector).append('<option value="' + "All" + '">' + "All" + '</option>');
        for (var key in locations){
            $(locationSelector).append('<option value="' + key + '">' + key + '</option>');
        }
    }else if($("#type-selector").val() == "Outdoor"){
        $(locationSelector).append('<option value="' + "All" + '">' + "All" + '</option>');
        for (var key in locations){
            for(var region in locations[key]){
                var needed = false;
                for(var i = 0; i < projects.length; i ++){
                    if (projects[i].getAttribute("data-location") == locations[key][region] && projects[i].getAttribute("data-type") == "Outdoor"){
                        needed = true;
                        break;
                    }
                }
                if(needed){
                    console.log("needed " +locations[key][region]);
                    $(locationSelector).append('<option value="' + locations[key][region] + '">' + locations[key][region] + '</option>');
                }
            }
        }
    }else {
        $(locationSelector).append('<option value="' + "All" + '">' + "All" + '</option>');
        for (var key in locations){
            for(var region in locations[key]){
                var needed = false;
                for(var i = 0; i < projects.length; i ++){
                    if (projects[i].getAttribute("data-location") == locations[key][region]){
                        needed = true;
                        break;
                    }
                }
                if(needed){
                    console.log("needed " +locations[key][region]);
                    $(locationSelector).append('<option value="' + locations[key][region] + '">' + locations[key][region] + '</option>');
                }
            }
        }
    }
}